#! /usr/bin/env perl
   use strict;
   use 5.010;
   use autodie;
   use Getopt::Long;
   my($in,$out,$help,$cutoff);
   GetOptions("in=s"=>\$in,"out=s"=>\$out,"help"=>\$help,"cutoff=s"=>\$cutoff);
   if($in and $out){
     open IN,'<',$in;
     open OUT,'>',$out;
     $cutoff=$cutoff?$cutoff:0;

     while(<IN>){
       chomp;
       unless(m/^Gene/){
         my @lines=split(/\t/,$_);
         my @cpms=sort {$a<=>$b} @lines[1..$#lines];
         if($cpms[-1]>0 and $cpms[-1]>=$cutoff){
           my $tsi=0;
           my $sum=0;
           foreach(@cpms){
             $sum +=$_;
          }
           $tsi =$cpms[-1]/$sum;
           $lines[0]=~s/\|/\t/g;
           print OUT $lines[0]."\t".$tsi."\n";
        }
      }
    }
     close IN;
     close OUT;
   }elsif($help){
      say"This script aims to count the TSI!\n\n
      --in:the input file;\n
      --cutoff:the cutoff for expresion;\n
      --out:the result file;\n
      --help:the help!\n";
   }else{
      print "Please read the help!\n";
   }
